namespace Magify
{
    public enum ProductObtainFailReason
    {
        Unknown,

        /// <summary>
        /// The time allocated for obtaining the product has expired
        /// </summary>
        Timeout,

        /// <summary>
        /// Obtainer for this product not found
        /// </summary>
        NoObtainer,

        /// <summary>
        /// This product requires internet connection to obtain
        /// </summary>
        NoInternet,

        #region Ads errors

        /// <summary>
        /// Can't show reward video
        /// TODO more error types for ads
        /// </summary>
        MediatorError,

        #endregion

        #region In-App errors

        /// <summary>
        /// There is another obtain operation in progress
        /// </summary>
        PurchasingIsBusy,

        /// <summary>
        /// In App Purchases is not initialized yet.
        /// </summary>
        PurchasingNotReady,

        /// <summary>
        /// In App Purchases disabled in device settings.
        /// </summary>
        PurchasingUnavailable,

        /// <summary>
        /// No products available for purchase,
        /// Typically indicates a configuration error.
        /// </summary>
        NoProductsAvailable,

        /// <summary>
        /// The store reported the app as unknown.
        /// Typically indicates the app has not been created
        /// on the relevant developer portal, or the wrong
        /// identifier has been configured.
        /// </summary>
        AppNotKnown,

        /// <summary>
        /// Another purchase is already in progress.
        /// </summary>
        ExistingPurchasePending,

        /// <summary>
        /// The product was reported unavailable by the purchasing system.
        /// </summary>
        ProductUnavailable,

        /// <summary>
        /// Signature validation of the purchase's receipt failed.
        /// </summary>
        SignatureInvalid,

        /// <summary>
        /// The user opted to cancel rather than proceed with the purchase.
        /// This is not specified on platforms that do not distinguish
        /// cancellation from other failure (Amazon, Microsoft).
        /// </summary>
        UserCancelled,

        /// <summary>
        /// There was a problem with the payment.
        /// This is unique to Apple platforms.
        /// </summary>
        PaymentDeclined,

        /// <summary>
        /// The transaction has already been completed successfully. This error can occur
        /// on Apple platforms if the transaction is finished successfully while the user
        /// is logged out of the app store, using a receipt generated while the user was
        /// logged in.
        /// </summary>
        DuplicateTransaction,

        /// <summary>
        /// The subscription was purchased and has not expired yet.
        /// </summary>
        SubscriptionAlreadyBought,

        #endregion
    }
}