﻿using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    internal class InternalLinkProductObtainer : ProductObtainer<InternalLinkProduct>
    {
        private static readonly MagifyLogger _logger = MagifyLogger.Get(MagifyService.LogScope);

        [CanBeNull]
        private readonly IAppNavigator _navigator;

        public InternalLinkProductObtainer(IAppNavigator navigator)
        {
            _navigator = navigator;
        }

        public override bool CanObtainProduct(ProductDef product)
        {
            return _navigator != null && base.CanObtainProduct(product);
        }

        private protected override async UniTask<ProductObtainResult> ObtainProductAsync(InternalLinkProduct product, CampaignRequest request, CancellationToken cancellationToken)
        {
            _logger.Log($"Obtaining {product.GetType().Name} ({product.Id}): to obtain an internal link product, we need to follow the application link.");
            var internalLink = product.Link;
            _logger.Log($"Follow application link: {internalLink}");
            await _navigator!.NavigateTo(internalLink, cancellationToken);
            _logger.Log($"Navigated to {internalLink}");
            return new ProductObtainResult(product, request);
        }
    }
}