﻿using System.Threading;
using Cysharp.Threading.Tasks;
using UnityEngine;

namespace Magify
{
    internal class ExternalLinkProductObtainer : ProductObtainer<ExternalLinkProduct>
    {
        private static readonly MagifyLogger _logger = MagifyLogger.Get(MagifyService.LogScope);

        private protected override async UniTask<ProductObtainResult> ObtainProductAsync(ExternalLinkProduct product, CampaignRequest request, CancellationToken cancellationToken)
        {
            _logger.Log($"Obtaining {product.GetType().Name} ({product.Id}): to obtain an external link product, we need to follow the link and wait for the user to return.");
            var url = product.Url;
            _logger.Log($"Opening url and wait for the user to return: {url}");
            var restoreType = await ApplicationHelper.CallAndWaitForApplicationRestore(() => Application.OpenURL(url), cancellationToken);
            _logger.Log($"The use went out of the background after opening link. Restore type is {restoreType}");
            return new ProductObtainResult(product, request);
        }
    }
}