﻿using System.Collections;
using System.Collections.Generic;

namespace Magify
{
    public class CustomEvent : IDictionary<string, object>, IReadOnlyDictionary<string, object>
    {
        public string Name { get; }
        public Dictionary<string, object> Params { get; }

        public object this[string key]
        {
            get => Params[key];
            set => Params[key] = value;
        }

        public CustomEvent(string name, Dictionary<string, object> @params = null)
        {
            Name = name;
            Params = @params ?? new Dictionary<string, object>();
        }

        public T Get<T>(string key) => (T)this[key];
        public void Set<T>(string key, T value) => this[key] = value;

        IEnumerator IEnumerable.GetEnumerator() => Params.GetEnumerator();
        IEnumerable<string> IReadOnlyDictionary<string, object>.Keys => Params.Keys;
        IEnumerable<object> IReadOnlyDictionary<string, object>.Values => Params.Values;
        void ICollection<KeyValuePair<string, object>>.Add(KeyValuePair<string, object> item) => Params.Add(item.Key, item.Value);
        bool ICollection<KeyValuePair<string, object>>.Contains(KeyValuePair<string, object> item) => ((ICollection<KeyValuePair<string, object>>)Params).Contains(item);
        void ICollection<KeyValuePair<string, object>>.CopyTo(KeyValuePair<string, object>[] array, int arrayIndex) => ((ICollection<KeyValuePair<string, object>>)Params).CopyTo(array, arrayIndex);
        bool ICollection<KeyValuePair<string, object>>.Remove(KeyValuePair<string, object> item) => ((ICollection<KeyValuePair<string, object>>)Params).Remove(item);
        int ICollection<KeyValuePair<string, object>>.Count => Params.Count;
        bool ICollection<KeyValuePair<string, object>>.IsReadOnly => ((ICollection<KeyValuePair<string, object>>)Params).IsReadOnly;
        ICollection<string> IDictionary<string, object>.Keys => Params.Keys;
        ICollection<object> IDictionary<string, object>.Values => Params.Values;
        int IReadOnlyCollection<KeyValuePair<string, object>>.Count => Params.Count;

        public IEnumerator<KeyValuePair<string, object>> GetEnumerator() => Params.GetEnumerator();
        public void Clear() => Params.Clear();
        public void Add(string key, object value) => Params.Add(key, value);
        public bool ContainsKey(string key) => Params.ContainsKey(key);
        public bool TryGetValue(string key, out object value) => Params.TryGetValue(key, out value);
        public bool Remove(string key) => Params.Remove(key);
    }
}