#if UNITY_EDITOR && UNITY_IOS
using System.IO;
using UnityEditor;
using UnityEditor.Build;
using UnityEditor.Build.Reporting;
using UnityEditor.iOS.Xcode;

namespace Magify.PlayerBuilder
{
    public partial class MagifyBuildUtilities
    {
        public class PlistPostprocessor : IPostprocessBuildWithReport // Will execute after XCode project is built
        {
            int IOrderedCallback.callbackOrder => MagifyBuildConfig.PostprocessorsCallbackOrder;

            public void OnPostprocessBuild(BuildReport report)
            {
                if (report.summary.platform != BuildTarget.iOS) return;
                Log($"{nameof(PlistPostprocessor)} enabled: {MagifyBuildConfig.AutoPatchPlistOnBuild}");
                if (!MagifyBuildConfig.AutoPatchPlistOnBuild) return;
                Log("Getting path to the plais");
                var plistPath = report.summary.outputPath + "/Info.plist";
                UpdatePlist(plistPath);
            }
        }

        static partial void UpdatePlistPartial(string plistPath)
        {
            Log($"{nameof(UpdatePlist)} Started.");
            if (!File.Exists(plistPath))
            {
                throw new MagifyBuildException($"Invalid path to Info.plist: {plistPath}");
            }
            Log($"Load ios plist at {plistPath}");
            var plist = new PlistDocument();
            plist.ReadFromString(File.ReadAllText(plistPath));

            Log("Collecting ios app schemas for cross-promo");
            var schemas = MagifyBuildConfig.GetAllIOSAppSchemas();

            Log($"Adding app schemas to plist (total is {schemas.Count}\n{string.Join("\n", schemas)}");
            var root = plist.root;
            var schemes = new PlistElementArray();
            const string urlSchemesKey = "LSApplicationQueriesSchemes";
            foreach (string schema in schemas)
            {
                schemes.AddString(schema);
            }
            root[urlSchemesKey] = schemes;

            Log("Save the new manifest");
            plist.WriteToFile(plistPath);

            Log($"Final AndroidManifest:\n{File.ReadAllText(plistPath)}");
            Log($"{nameof(UpdatePlist)} Finished");
        }
    }
}
#endif