﻿using System;
using System.Collections.Generic;
using UnityEngine.UIElements;

namespace Magify.DependenciesInstaller
{
    internal static class Extensions
    {
        public static T With<T>(this T value, Action<T> action)
        {
            action.Invoke(value);
            return value;
        }

        public static void Add<T>(this VisualElement element, IEnumerable<T> items)
            where T : VisualElement
        {
            foreach (var item in items)
                element.Add(item);
        }
    }
}