﻿using UnityEditor;
using UnityEngine;

#if UNITY_EDITOR

namespace Magify
{
    public static class CameraFrustumGizmo
    {
        [DrawGizmo(GizmoType.NonSelected | GizmoType.Active)]
        public static void DrawGizmoForMyScript(Camera cam, GizmoType gizmoType)
        {
            if (cam == null)
            {
                return;
            }
            var temp = Gizmos.matrix;
            var t = cam.transform;

            Gizmos.matrix = Matrix4x4.TRS(t.position, t.rotation, Vector3.one);

            if (cam.orthographic)
            {
                float spread = cam.farClipPlane - cam.nearClipPlane;
                float center = (cam.farClipPlane + cam.nearClipPlane) * 0.5f;
                Gizmos.DrawWireCube(new Vector3(0, 0, center), new Vector3(cam.orthographicSize * 2 * cam.aspect, cam.orthographicSize * 2, spread));
            }
            else
            {
                Gizmos.DrawFrustum(Vector3.zero, cam.fieldOfView, cam.farClipPlane, cam.nearClipPlane, cam.aspect);
            }
            Gizmos.matrix = temp;
        }
    }
}

#endif