﻿using System;
using System.Collections.Generic;
using System.Linq;
using TMPro;
using UnityEngine;

namespace Magify
{
    public class BundleLocalizationTextSwitcher : MonoBehaviour
    {
        [Serializable]
        internal struct LocalizationText
        {
            [field: SerializeField]
            public string LocaleKey { get; set; }

            [field: SerializeField]
            public string LocalizedString { get; set; }
        }

        [field: SerializeField]
        internal TMP_Text TMPText { get; set; }

        [field: SerializeField]
        internal BundleLocalizationSwitcherContainer Container { get; set; }

        [field: SerializeField]
        internal List<LocalizationText> LocalizationTexts { get; private set; } = new();

        private object[] _parameters;

        public void SetParameters(params object[] parameters)
        {
            _parameters = parameters;
            UpdateText(Container.CurrentLocalizationCode);
        }

        internal void UpdateText(string localeCode)
        {
            var index = LocalizationTexts.FindIndex(t => t.LocaleKey == localeCode);
            var localizedText = index >= 0 ? LocalizationTexts[index].LocalizedString : LocalizationTexts.First(t => t.LocaleKey == BundleLocalizationConstants.DefaultLanguageCodeKey).LocalizedString;
            TMPText.text = _parameters != null ? Container.LocalizationRuntimeHelper.PluralFormat(index >= 0 ? localeCode : BundleLocalizationConstants.DefaultLanguageCodeKey, localizedText, _parameters) : localizedText;
        }
    }
}