﻿using System.Collections.Generic;
using UnityEngine;

namespace Magify
{
    internal class BundleLocalizationSwitcherContainer : MonoBehaviour
    {
        [field: SerializeField]
        public List<BundleLocalizationTextSwitcher> LocalizationSwitchers { get; private set; } = new();

        internal ILocalizationRuntimeHelper LocalizationRuntimeHelper { get; private set; }
        internal string CurrentLocalizationCode { get; private set; }

        private void Awake()
        {
#if UNITY_LOCALIZATION
            LocalizationRuntimeHelper = new UnityLocalizationRuntimeHelper();
#else
            LocalizationRuntimeHelper = new DefaultLocalizationHelper();
#endif

            CurrentLocalizationCode = LocalizationRuntimeHelper.GetCurrentLocale();
            foreach (var switcher in LocalizationSwitchers)
            {
                switcher.UpdateText(CurrentLocalizationCode);
            }
        }
    }
}