﻿#if UNITY_LOCALIZATION
using System.Collections.Generic;
using System.Linq;
using UnityEngine.Localization.SmartFormat;
using UnityEngine.Localization.SmartFormat.Core.Extensions;
using UnityEngine.Localization.SmartFormat.Core.Formatting;
using UnityEngine.Localization.SmartFormat.Core.Parsing;

namespace Magify
{
    internal class BundleLiteralCharacterExtractor : SmartFormatter
    {
        private IEnumerable<char> m_Characters;

        public BundleLiteralCharacterExtractor(SmartFormatter parent)
        {
            Settings = parent.Settings;
            Parser = parent.Parser;
            SourceExtensions.AddRange(parent.SourceExtensions);
            FormatterExtensions.AddRange(parent.FormatterExtensions);
        }

        public IEnumerable<char> ExtractLiteralsCharacters(string value)
        {
            m_Characters = string.Empty;
            Format(value, null);
            return m_Characters;
        }

        public override void Format(FormattingInfo formattingInfo)
        {
            foreach (var item in formattingInfo.Format.Items)
            {
                if (item is LiteralText)
                {
                    m_Characters = m_Characters.Concat(item.ToEnumerable());
                    continue;
                }

                var placeholder = (Placeholder)item;
                var childFormattingInfo = formattingInfo.CreateChild(placeholder);

                var formatterName = childFormattingInfo.Placeholder.FormatterName;

                foreach (var formatterExtension in FormatterExtensions)
                {
                    if (formatterExtension is IFormatterLiteralExtractor literalExtractor &&
                        formatterExtension.Names.Contains(formatterName))
                    {
                        literalExtractor.WriteAllLiterals(childFormattingInfo);
                    }
                }
            }
        }
    }
}
#endif