#if UNITY_EDITOR && MAGIFY_ADVANCED
using FluentAssertions;
using NUnit.Framework;
using Magify.Rx;

namespace Magify.Tests
{
    internal partial class MagifyServiceTests
    {
        public class StoredAppFeatures : MagifyServiceTestsPart
        {
            [Test]
            [TestCase(NetworkState.Reachable, 1)]
            [TestCase(NetworkState.NotReachable, 0)]
            public void StartNewSession_ThenStoredAppFeaturedLoadingCalled(NetworkState networkState, int expectedCallbacks)
            {
                // Arrange
                var callbacks = 0;
                using var _ = Service.OnStoredAppFeaturesLoadingRequested.Subscribe(_ => callbacks++);
                var net = new TestNetworkStatusProvider();
                net.Reachability.Value = networkState;
                Service.SetINetworkStatusProvider(net);

                // Act
                Service.StartNewSession();

                // Assert
                callbacks.Should().Be(expectedCallbacks);
            }

            [Test]
            public void StartNewSession_NetworkRestored_ThenStoredAppFeaturedLoadingCalled()
            {
                // Arrange
                var callbacks = 0;
                using var _ = Service.OnStoredAppFeaturesLoadingRequested.Subscribe(_ => callbacks++);
                var net = new TestNetworkStatusProvider();
                net.Reachability.Value = NetworkState.NotReachable;
                Service.SetINetworkStatusProvider(net);

                // Act
                Service.StartNewSession();
                net.Reachability.Value = NetworkState.Reachable;

                // Assert
                callbacks.Should().Be(1);
            }
        }
    }
}
#endif