﻿using System.Collections.Generic;
using FluentAssertions;
using FluentAssertions.Primitives;

namespace Magify.Tests
{
    internal static class AssertionExtensions
    {
        public static AndConstraint<BooleanAssertions> ShouldBeSameInAnyOrder<T>(this IReadOnlyCollection<T> first, IReadOnlyCollection<T> second, string because = "", params object[] becauseArgs)
        {
            return first.EqualsInAnyOrder(second).Should()!.BeTrue(because, becauseArgs);
        }
    }
}