﻿using FluentAssertions;
using Magify.Rx;
using NUnit.Framework;

namespace Magify.Tests
{
    internal class SkipLatestValueOnSubscribeTests
    {
        [Test]
        [TestCase(true)]
        [TestCase(false)]
        public void WhenPropertyCreated_AndSkipLatestValueOnSubscribe_ThenNothingReceived(bool skipLatestValue)
        {
            // Arrange
            const string initialValue = "hello!";
            var received = default(object);
            using var property = new ReactiveProperty<object>(initialValue);

            // Act
            var observable = skipLatestValue ? property.SkipLatestValueOnSubscribe() : property;
            using var _ = observable.Subscribe(v => received = v);

            // Assert
            var expected = skipLatestValue ? null : initialValue;
            received.Should()!.Be(expected);
        }

        [Test]
        [TestCase(true)]
        [TestCase(false)]
        public void WhenPropertyCreated_AndSkipLatestValueOnSubscribe_AndSetSecondValue_ThenSecondValueOk(bool skipLatestValue)
        {
            // Arrange
            const string initialValue = "hello!";
            const string secondValue = "second hello!";
            var received = default(object);
            using var property = new ReactiveProperty<object>(initialValue);

            // Act
            var observable = skipLatestValue ? property.SkipLatestValueOnSubscribe() : property;
            using var _ = observable.Subscribe(v => received = v);
            property.Value = secondValue;

            // Assert
            received.Should()!.Be(secondValue);
            property.Value.Should()!.Be(secondValue);
        }
    }
}