using System;
using System.Linq;
using FluentAssertions;
using NUnit.Framework;

namespace Magify.Tests
{
    public class EmbeddedLocalizerTests
    {
        private static LocalizationKey[] LocalizationKeys { get; } = Enum.GetValues(typeof(LocalizationKey)).Cast<LocalizationKey>().ToArray();
        private static ErrorPopup.Type[] Errors { get; } = Enum.GetValues(typeof(ErrorPopup.Type)).Cast<ErrorPopup.Type>().ToArray();
        private static ILocalizer EmbeddedLocalizer { get; } = new EmbeddedLocalizer();

        [TestCaseSource(nameof(LocalizationKeys))]
        public void WhenEmbeddedLocalizerUsed_AndTranslationRequested_ThenResultIsNotEmpty(LocalizationKey key)
        {
            // Act
            var translatedValue = EmbeddedLocalizer.Localize(key);

            // Assert
            translatedValue.Should().NotBeNull();
            translatedValue.Should().NotBe(string.Empty);
        }

        [TestCaseSource(nameof(Errors))]
        public void WhenEmbeddedLocalizerUsed_AndTranslationRequested_ThenResultIsNotEmpty(ErrorPopup.Type error)
        {
            // Act
            var translatedValue = EmbeddedLocalizer.Localize(error);

            // Assert
            translatedValue.Should().NotBeNull();
            translatedValue.Should().NotBe(string.Empty);
        }
    }
}