﻿using System;

namespace Magify.Tests
{
    [AttributeUsage(AttributeTargets.Method, AllowMultiple = true, Inherited = false)]
    public class UnitTestTargetAttribute : Attribute
    {
        public Type Type { get; }
        public string MethodName { get; }

        public UnitTestTargetAttribute(Type type, string methodName)
        {
            Type = type;
            MethodName = methodName;
        }

        public string GetMethodFullPath()
        {
            return $"{Type.FullName}.{MethodName}";
        }
    }
}