﻿#if UNITY_EDITOR
using Magify.Tests;
using UnityEditor;
using UnityEngine;
using UnityEngine.UIElements;

namespace Magify
{
    public class TestCoverageWindow : EditorWindow
    {
        [MenuItem("Tools/TestCoverageWindow")]
        private static void ShowWindow()
        {
            var window = GetWindow<TestCoverageWindow>();
            window.titleContent = new GUIContent("TITLE");
            window.Show();
        }

        private void OnEnable()
        {
            var (testedList, notTestedList) = TestCoverage.Check();
            var tested = new ListView(testedList)
            {
                style =
                {
                    width = new StyleLength(new Length(50, LengthUnit.Percent)),
                    backgroundColor = new StyleColor(new Color(0.31f,0.78f,0.47f, 0.3f))
                }
            };
            var notTested = new ListView(notTestedList)
            {
                style =
                {
                    width = new StyleLength(new Length(50, LengthUnit.Percent)),
                    backgroundColor = new StyleColor(new Color(0.92f,0.30f,0.26f, 0.3f))
                }
            };
            var container = new Box()
            {
                style =
                {
                    flexDirection = FlexDirection.Row
                }
            };
            container.Add(tested);
            container.Add(notTested);
            rootVisualElement.Add(container);
        }
    }
}
#endif