using System.Threading;
using JetBrains.Annotations;
using NUnit.Framework;

namespace Magify.Tests
{
    internal partial class MinimalMagifyClientTests
    {
        internal class MinimalMagifyClientTestsPart
        {
            [SetUp]
            [TearDown]
            public void ClearAllData()
            {
                EditorModeTestsEnvironment.Clear();
            }

            protected CancellationToken GetCancellationToken(int cancelDelay = 1000)
            {
                return new CancellationTokenSource(cancelDelay).Token;
            }
        }

        private const string AppName = "TestApp";
        private const string ConfigPath = "";
        private const Environment OfflineEnvironment = Environment.Offline;

        [NotNull]
        private static MinimalMagifyClient CreateDefault(Environment? environment = Environment.Staging, INetworkClient networkClient = default, EditorDevice editorDevice = default)
        {
            editorDevice ??= EditorDevice.GetDefaultAndroidDevice();
            return networkClient == null
                ? new MinimalMagifyClient(AppName, ConfigPath, EditorModeTestsEnvironment.RootStoragePath, environment ?? OfflineEnvironment)
                : new MinimalMagifyClient(AppName, ConfigPath, EditorModeTestsEnvironment.RootStoragePath, environment ?? OfflineEnvironment, editorDevice, networkClient);
        }

        [NotNull]
        private static MinimalMagifyClient CreateDefaultAndInit(Environment? environment = Environment.Staging, INetworkClient networkClient = default, EditorDevice editorDevice = default)
        {
            editorDevice ??= EditorDevice.GetDefaultAndroidDevice();
            var client = networkClient == null
                ? new MinimalMagifyClient(AppName, ConfigPath, EditorModeTestsEnvironment.RootStoragePath, environment ?? OfflineEnvironment)
                : new MinimalMagifyClient(AppName, ConfigPath, EditorModeTestsEnvironment.RootStoragePath, environment ?? OfflineEnvironment, editorDevice, networkClient);
            client.InitializeSdk();
            return client;
        }

        [NotNull]
        private static MinimalAnalyticsTracker GetAnalyticsTracker([NotNull] MinimalMagifyClient magifyClient)
        {
            return GetPrivateField<MinimalAnalyticsTracker>(magifyClient, "_analyticsTracker");
        }

        [NotNull]
        private static ServerApi GetServerApi([NotNull] MinimalMagifyClient magifyClient)
        {
            return GetPrivateField<ServerApi>(magifyClient, "_serverApi");
        }

        [NotNull]
        private static MinimalAnalyticsService GetMinimalAnalyticsService([NotNull] MinimalMagifyClient magifyClient)
        {
            return GetPrivateField<MinimalAnalyticsService>(magifyClient, "_analyticsService");
        }

        [NotNull]
        private static PlatformAPI GetPlatformAPI([NotNull] MinimalMagifyClient magifyClient)
        {
            return GetPrivateField<PlatformAPI>(magifyClient, "_platform");
        }

        [NotNull]
        private static GeneralPrefs GetGeneralPrefs([NotNull] MinimalMagifyClient magifyClient)
        {
            return GetPrivateField<GeneralPrefs>(magifyClient, "_generalPrefs");
        }

        [NotNull]
        private static SessionCounter GetSessionCounter([NotNull] MinimalMagifyClient magifyClient)
        {
            return GetPrivateField<SessionCounter>(magifyClient, "_sessionCounter");
        }

        [NotNull]
        private static PurchaseTracker GetPurchaseTracker([NotNull] MinimalMagifyClient magifyClient)
        {
            return GetPrivateField<PurchaseTracker>(magifyClient, "_purchaseTracker");
        }

        [NotNull]
        private static T GetPrivateField<T>([NotNull] MinimalMagifyClient client, [NotNull] string fieldName)
            where T : class
        {
            return (client
                    .GetType()
                    .GetField(fieldName, System.Reflection.BindingFlags.NonPublic | System.Reflection.BindingFlags.Instance)
                    !.GetValue(client)
                    as T)!;
        }
    }
}