using FluentAssertions;
using Magify.Model;
using NUnit.Framework;

namespace Magify.Tests
{
    internal partial class MagifyClientTests
    {
        public class IsGeoIpEnabled : MagifyClientTestsPart
        {
            private static object[] DeviceToIsGeoIpRequirement => new object[]
            {
                new object[] {EditorDevice.GetDefaultAndroidDevice(), true, ClientKind.Full},
                new object[] {EditorDevice.GetDefaultAndroidDevice(), true, ClientKind.Minimal},
                new object[] {EditorDevice.GetDefaultIOSDevice(), true, ClientKind.Full},
                new object[] {EditorDevice.GetDefaultIOSDevice(), true, ClientKind.Minimal},
            };

            [Test]
            [TestCaseSource(nameof(DeviceToIsGeoIpRequirement))]
            public void WhenMagifyClientInit_AuthTokenPayloadMustNotContainsIsIdfaAvailable(EditorDevice device, bool requiresIsGeoIpFlag, ClientKind kind)
            {
                // Arrange
                using var magifyClient = CreateDefaultAndInit(kind: kind, editorDevice: device);

                // Act
                magifyClient.IsGeoIpEnabled.Value = false;

                // Assert
                var tokenPayload = (AuthTokenPayload)GetServerApi(magifyClient).CreateNewTokenRequestPayloadNonStatic().Payload;
                if (requiresIsGeoIpFlag) tokenPayload.IsGeoIPEnabled.Should().HaveValue();
                else tokenPayload.IsGeoIPEnabled.Should().NotHaveValue();
            }
        }
    }
}