﻿using FluentAssertions;
using Magify.Model;
using NUnit.Framework;

namespace Magify.Tests
{
    internal class LocaleDataTests
    {
        [Test]
        [TestCase("en-US", "US")]
        [TestCase("ru-RU", "RU")]
        [TestCase("de-DE", "DE")]
        public void CreateLocaleDataFromLanguageWithRegionString(string languageWithRegion, string countryCode)
        {
            // Act
            var localeData = new LocaleData(languageWithRegion);

            // Assert
            localeData.CountryCode.Should().Be(countryCode);
            localeData.LanguageWithRegion.Should().Be(languageWithRegion);
        }

        [Test]
        [TestCase("en-US", "US")]
        [TestCase("ru-RU", "RU")]
        [TestCase("de-DE", "DE")]
        public void CreateLocaleDataFromCountryCodeAndLanguageWithRegion(string languageWithRegion, string countryCode)
        {
            // Act
            var localeData = new LocaleData(countryCode, languageWithRegion);

            // Assert
            localeData.CountryCode.Should().Be(countryCode);
            localeData.LanguageWithRegion.Should().Be(languageWithRegion);
        }

        [Test]
        [TestCase("en-US", "{\"languageWithRegion\":\"en-US\",\"countryCode\":\"US\"}")]
        [TestCase("ru-RU", "{\"languageWithRegion\":\"ru-RU\",\"countryCode\":\"RU\"}")]
        [TestCase("de-DE", "{\"languageWithRegion\":\"de-DE\",\"countryCode\":\"DE\"}")]
        public void SerializeLocaleData(string languageWithRegion, string expectedSerialized)
        {
            // Arrange
            var localeData = new LocaleData(languageWithRegion);

            // Act
            var serialized = localeData.ToString();

            // Assert
            serialized.Should().Be(expectedSerialized);
        }
    }
}