﻿using NUnit.Framework;
using FluentAssertions;

namespace Magify.Tests
{
    public class LanguageTagUtilsTests
    {
        [Test]
        [TestCase("us-EN", true)]
        [TestCase("ru-RU", true)]
        [TestCase("us-En", true)]
        [TestCase("zh-Hans", true)]
        [TestCase("zh-Hant", true)]
        [TestCase("us-en", false)]
        [TestCase("US-En", false)]
        [TestCase("us-", false)]
        [TestCase("-EN", false)]
        [TestCase("us", false)]
        [TestCase("EN", false)]
        [TestCase("-", false)]
        [TestCase("", false)]
        public void IsValid_ShouldReturnExpectedResult(string languageTag, bool expected)
        {
            // Arrange
            // Act
            var result = LanguageTagUtils.IsValid(languageTag);

            // Assert
            result.Should().Be(expected);
        }

        [Test]
        [TestCase("us", true)]
        [TestCase("us-", true)]
        [TestCase("ru", true)]
        [TestCase("ru-", true)]
        [TestCase("us-EN", false)]
        [TestCase("us-en", false)]
        [TestCase("us-En", false)]
        [TestCase("US-En", false)]
        [TestCase("-EN", false)]
        [TestCase("EN", false)]
        [TestCase("-", false)]
        [TestCase("", false)]
        public void HasOnlyLanguage_ShouldReturnExpectedResult(string languageTag, bool expected)
        {
            // Arrange
            // Act
            var result = LanguageTagUtils.HasOnlyLanguage(languageTag);

            // Assert
            result.Should().Be(expected);
        }

        [Test]
        [TestCase("us", "us-US")]
        [TestCase("us-", "us-US")]
        [TestCase("rarelonglangname", "rarelonglangname-RARELONGLANGNAME")]
        [TestCase("rarelonglangname-", "rarelonglangname-RARELONGLANGNAME")]
        [TestCase("s", "s-S")]
        [TestCase("s-", "s-S")]
        public void OnlyLanguageToFull_ShouldReturnExpectedResult(string languageTag, string expected)
        {
            // Arrange
            // Act
            var result = LanguageTagUtils.OnlyLanguageToFull(languageTag);

            // Assert
            result.Should().Be(expected);
        }
    }
}