using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Magify.Model;

namespace Magify.Tests
{
    internal partial class ContextListenerTests
    {
        [NotNull]
        internal static Dictionary<string, ContentGroup> CreateContentGroups()
        {
            var groups = new Dictionary<string, ContentGroup>();
            groups.Add("id", new ContentGroup()
            {
                Items = new List<Model.ContentItem>(),
            });
            return groups;
        }

        [NotNull]
        internal static SubsystemsCollection CreateSubsystems([NotNull] out LimitsHolder limitsHolder, [NotNull] out LtoCampaignManager ltoCampaignManager)
        {
            var subsystems = new SubsystemsCollection();
            var platform = new PlatformDefault().AddTo(subsystems);
            var appVersionProvider = new AppVersionProvider().AddTo(subsystems);
            var generalPrefs = GeneralPrefs.Create(EditorModeTestsEnvironment.GeneralPrefsPath, EditorModeTestsEnvironment.LocalGeneralPrefsPath, appVersionProvider).AddTo(subsystems);
            var sessionCounter = new SessionCounter(generalPrefs, platform).AddTo(subsystems);
            var offersPrefs = OffersPrefs.Create(EditorModeTestsEnvironment.OffersPrefsName).AddTo(subsystems);
            var campaignsCollection = new CampaignsCollection().AddTo(subsystems);
            var countersStorage = new CountersStorage(EditorModeTestsEnvironment.CountersFolderPath).AddTo(subsystems);
            var counters = new Counters(countersStorage).AddTo(subsystems);
            limitsHolder = new LimitsHolder(generalPrefs, sessionCounter).AddTo(subsystems);
            var campaignsTracker = new CampaignsTracker(generalPrefs, counters, limitsHolder, platform).AddTo(subsystems);
            ltoCampaignManager = new LtoCampaignManager(campaignsTracker, campaignsCollection, generalPrefs, offersPrefs, platform, counters, EditorModeTestsEnvironment.RootStoragePath, appVersionProvider).AddTo(subsystems);
            subsystems.InitializeAll();
            return subsystems;
        }

        [NotNull]
        internal static CampaignsContext CreateCampaignsContext()
        {
            var context = new CampaignsContext();
            context.CampaignModels = GetCampaignModels();
            context.Content = CreateContentGroups();
            context.DefaultProducts = GetDefaultProducts();
            context.AssignedAbTests = GetAbTestInfos();
            context.Limits = GetLimits();
            context.Segmentations = new []{"segmentation1", "segmentation2", "segmentation3"};
            context.DefaultContent = GetDefaultContent();
            return context;
        }

        [NotNull]
        private static List<CampaignModel> GetCampaignModels()
        {
            var models = new List<CampaignModel>();
            models.Add(CreateCampaignModel("CampaignModel1"));
            models.Add(CreateCampaignModel("CampaignModel2"));
            return models;
        }

        [NotNull]
        private static List<DefaultContentItem> GetDefaultContent()
        {
            var defaultContent = new List<DefaultContentItem>();
            defaultContent.Add(new DefaultContentItem
            {
                Name = "name1",
                Type = "type1",
                Filename = "filename1",
                Image = "image1"
            });
            defaultContent.Add(new DefaultContentItem
            {
                Name = "name2",
                Type = "type2",
                Filename = "filename2",
                Image = "image2"
            });
            return defaultContent;
        }

        private static Magify.Model.Limits GetLimits()
        {
            var limits = new Magify.Model.Limits();
            limits.GlobalInterval = new TimeSpan(1,0,0,0);
            limits.SessionsInterval = new TimeSpan(0,1,0,0);
            limits.InterstitialInterval = new TimeSpan(0,0,1,0);
            limits.ImpressionsPerSession = 0;
            limits.TempLimits = new List<TemporaryLimitsGroup>();
            var item = new TemporaryLimitsGroup();
            item.IncludeIfAnyPurchased = new List<PurchasedItem>();
            var purchasedItem = new PurchasedItem();
            purchasedItem.Product = "product";
            item.IncludeIfAnyPurchased.Add(purchasedItem);
            limits.TempLimits.Add(item);
            return limits;
        }

        [NotNull]
        private static List<AbTestInfo> GetAbTestInfos()
        {
            var abTestInfos = new List<AbTestInfo>();
            var info = new AbTestInfo();
            info.Name = "name1";
            info.Group = "group1";
            abTestInfos.Add(info);
            var testInfo = new AbTestInfo();
            testInfo.Name = "name2";
            testInfo.Group = "group2";
            abTestInfos.Add(testInfo);
            return abTestInfos;
        }

        [NotNull]
        private static List<DefaultProduct> GetDefaultProducts()
        {
            var list = new List<DefaultProduct>();
            var item = new DefaultProduct();
            item.ProductId = "id";
            item.Type = ProductType.Subscription;
            item.ProductContext = new Dictionary<string, object>();
            list.Add(item);
            return list;
        }

        internal static CampaignRecord GetCampaignRecord()
        {
            var info = new CampaignInfo()
            {
                Name = "campaignInfoName",
            };
            var campaignModel = new CampaignModel()
            {
                Name = "campaignModelName",
                Spots = new List<Spot>(),
                Duration = new TimeSpan(1, 0, 0, 0)
            };
            campaignModel.Spots.Add(new Spot
            {
                Name = "spotName",
            });
            var campaignRecord = new CampaignRecord(info, campaignModel);
            return campaignRecord;
        }

        [NotNull]
        private static CampaignModel CreateCampaignModel(string name)
        {
            return new()
            {
                Name = name,
                Type = CampaignType.Banner,
                Info = new ()
                {
                    BannerPosition = Model.BannerPosition.Bottom,
                },
            };
        }
    }
}