﻿using System;
using System.Linq;
using FluentAssertions;
using JetBrains.Annotations;
using NUnit.Framework;
using UnityEngine;

namespace Magify.Tests
{
    internal class ConfigScopeTests
    {
        [NotNull]
        private static object[] ToStringArrayTestCases()
        {
            return new object[]
            {
                new object[] { ConfigScope.None, null },
                new object[] { ConfigScope.Limits | ConfigScope.Campaigns, new[] { "limits", "campaigns" } },
                new object[] { ConfigScope.ProductIds | ConfigScope.AppFeatures, new[] { "product_ids", "app_features" } },
            };
        }

        [Test]
        [TestCaseSource(nameof(ToStringArrayTestCases))]
        public void ToStringArray(ConfigScope scope, [CanBeNull] string[] expected)
        {
            // Arrange
            // Act
            var array = scope.ToStringArray();

            // Assert
            if (expected == null)
            {
                array.Should().BeNull();
            }
            else
            {
                array.EqualsInAnyOrder(expected).Should().BeTrue();
            }
        }

        [Test]
        public void AllIncludesAll()
        {
            // Arrange
            // Act
            var all = ConfigScopeExtensions.All();
            // Get all values in the enum and combine them, excluding "None"
            var combinedValue = Enum.GetValues(typeof(ConfigScope))
                .Cast<Enum>()
                .Where(value => Convert.ToInt64(value) != 0) // Exclude None (assumed to be 0)
                .Aggregate(0L, (current, next) => current | Convert.ToInt64(next));

            // Assert
            ((ConfigScope)combinedValue == all).Should().BeTrue();
            Debug.Log($"[{string.Join(", ", ((ConfigScope)combinedValue).ToStringArray()!)}]");
        }
    }
}