﻿using System.Linq;
using Magify.Model;
using NUnit.Framework;

namespace Magify.Tests
{
    internal class CampaignParsingTests
    {
        [Test]
        public void AllCampaignsParsersExist()
        {
            var campaignTypes = typeof(CampaignType).GetEnumValues();
            foreach (var campaignType in campaignTypes.OfType<CampaignType>())
            {
                var exist = CampaignMapper.Parsers.TryGetValue(campaignType, out var parser);
                Assert.IsTrue(exist && parser != null);
            }
        }

        [Test]
        public void AllProductsParsersExist()
        {
            var productTypes = typeof(ProductType).GetEnumValues();
            foreach (var productType in productTypes)
            {
                var exist = CampaignParser.ProductsParsers.TryGetValue((Magify.Model.ProductType)productType, out var parser);
                Assert.IsTrue(exist && parser != null);
            }
        }

        [Test]
        public void AllCreativesParsersExist()
        {
            var creativeTypes = typeof(CreativeType).GetEnumValues();
            foreach (var creativeType in creativeTypes)
            {
                var exist = CampaignParser.CreativeParsers.TryGetValue((CreativeType)creativeType, out var parser);
                Assert.IsTrue(exist && parser != null);
            }
        }

        [Test]
        public void AllInterSplashScreenParsersExist()
        {
            var splashTypes = typeof(SplashType).GetEnumValues();
            foreach (var splashType in splashTypes)
            {
                var exist = CampaignParser.SplashScreenParsers.TryGetValue((SplashType)splashType, out var parser);
                Assert.IsTrue(exist && parser != null);
            }
        }
    }
}