﻿using System;

namespace Magify
{
    internal sealed class Subscription : IDisposable
    {
        private Action _onDisposeAction;

        public Subscription(Action onDisposeAction)
        {
            _onDisposeAction = onDisposeAction;
        }

        public void Dispose()
        {
            _onDisposeAction?.Invoke();
            _onDisposeAction = default;
        }
    }
}