using UnityEngine;
using UnityEngine.Video;

namespace Magify
{
    public class RenderTextureColorCleaner : MonoBehaviour
    {
        [SerializeField]
        private VideoPlayer _videoPlayer;

        private void Start()
        {
            if (_videoPlayer == null) return;
            var renderTextureCache = RenderTexture.active;
            RenderTexture.active = _videoPlayer.targetTexture;
            GL.Clear(true, true, Color.clear);
            RenderTexture.active = renderTextureCache;
        }
    }
}