using System;
using JetBrains.Annotations;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using UnityEngine;
using UnityEngine.Scripting;

namespace Magify
{
    [Preserve]
    public class DateFormatConverter : IsoDateTimeConverter
    {
        [UsedImplicitly, Preserve]
        public DateFormatConverter(string format)
        {
            DateTimeFormat = format;
        }

        public override object ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)
        {
            try
            {
                return base.ReadJson(reader, objectType, existingValue, serializer);
            }
            catch (Exception e) when (objectType.IsGenericType && objectType.GetGenericTypeDefinition() == typeof(Nullable<>))
            {
                Debug.LogException(e);
                return null;
            }
        }
    }
}