﻿using System;
using System.Collections.Generic;
using System.Threading;
using JetBrains.Annotations;

namespace Magify
{
    internal sealed class DisposableCancellationToken : IDisposable
    {
        private readonly CancellationTokenSource _cancellationTokenSource = new();

        public CancellationToken Token => _cancellationTokenSource.Token;

        public void Dispose()
        {
            _cancellationTokenSource.Cancel();
            _cancellationTokenSource.Dispose();
        }
    }

    internal static class CompositeDisposableExtensions
    {
        public static CancellationToken GetOrCreateToken<T>([NotNull] this T disposables)
            where T: ICollection<IDisposable>
        {
            foreach (var disposable in disposables)
            {
                if (disposable is DisposableCancellationToken token)
                {
                    return token.Token;
                }
            }

            var newToken = new DisposableCancellationToken();
            disposables.Add(newToken);
            return newToken.Token;
        }
    }
}