﻿using System;
using System.Runtime.CompilerServices;
using JetBrains.Annotations;

namespace Magify
{
    public static class BoolExtensions
    {
        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public static void IfTrue(this bool value, [NotNull] Action action1)
        {
            if (value)
            {
                action1();
            }
        }

        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public static void IfTrue(this bool value, [NotNull] params Action[] actions)
        {
            if (value)
            {
                foreach (var action in actions)
                {
                    action();
                }
            }
        }

        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public static void IfFalse(this bool value, [NotNull] Action action)
        {
            if (!value)
            {
                action();
            }
        }

        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public static void IfFalse(this bool value, [NotNull] params Action[] actions)
        {
            if (!value)
            {
                foreach (var action in actions)
                {
                    action();
                }
            }
        }
    }
}