﻿using System;
using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    public static class BinaryTypeHandlerUtils
    {
        [NotNull]
        public static BinaryTypeHandler<TPrimitive> HandlerForPrimitive<TPrimitive>()
            where TPrimitive: struct
        {
            object handler = default(TPrimitive) switch
            {
                bool => BinaryTypeBoolean.Shared,
                char => BinaryTypeChar.Shared,
                byte => BinaryTypeByte.Shared,
                sbyte => BinaryTypeSByte.Shared,
                short => BinaryTypeInt16.Shared,
                ushort => BinaryTypeUInt16.Shared,
                int => BinaryTypeInt32.Shared,
                uint => BinaryTypeUInt32.Shared,
                long => BinaryTypeInt64.Shared,
                ulong => BinaryTypeUInt64.Shared,
                float => BinaryTypeSingle.Shared,
                double => BinaryTypeDouble.Shared,
                decimal => BinaryTypeDecimal.Shared,
                DateTime => BinaryTypeDateTime.Shared,
                Vector2 => BinaryTypeVector2.Shared,
                Vector3 => BinaryTypeVector3.Shared,
                _ => throw new ArgumentOutOfRangeException(),
            };
            return (BinaryTypeHandler<TPrimitive>)handler;
        }
    }
}