﻿using System.Linq;
using UnityEngine;
using UnityEngine.UI;

namespace Magify
{
    [AddComponentMenu("Layout/Arc Layout Group")]
    public class ArcLayoutGroup : LayoutGroup
    {
        public enum Align
        {
            Clockwise = 0,
            Counterclockwise = 1,
        }

        [SerializeField]
        private Align _align;
        [Range(0f, 360f)]
        [SerializeField]
        private float _arcAngle;
        [Range(0f, 360f)]
        [SerializeField]
        private float _offset;

        public override void CalculateLayoutInputVertical()
        {
        }

        public override void SetLayoutHorizontal()
        {
            CalculateRadial();
        }

        public override void SetLayoutVertical()
        {
            CalculateRadial();
        }

        private void CalculateRadial()
        {
            m_Tracker.Clear();

            var fOffsetAngle = _arcAngle / (rectChildren.Count - 1);
            var angle = _offset;

            foreach (var child in rectChildren.Where(child => child != null))
            {
                m_Tracker.Add(this, child,
                    DrivenTransformProperties.Anchors |
                    DrivenTransformProperties.AnchoredPosition |
                    DrivenTransformProperties.Pivot);

                var rect = rectTransform.rect;
                var childRect = child.rect;
                var semiAxisX = (rect.width - childRect.width) / 2f;
                var semiAxisY = (rect.height - childRect.height) / 2f;

                var vPos = toPositiveRad(Mathf.Atan2(semiAxisX * Mathf.Sin(angle * Mathf.Deg2Rad), semiAxisY * Mathf.Cos(angle * Mathf.Deg2Rad)));
                vPos = (_align == Align.Counterclockwise ? 1 : -1) * (angle % 360 * Mathf.Deg2Rad + vPos) / 2f;

                child.localPosition = new Vector3(semiAxisX * Mathf.Cos(vPos), semiAxisY * Mathf.Sin(vPos), 0);
                child.anchorMin = child.anchorMax = child.pivot = new Vector2(0.5f, 0.5f);
                angle += fOffsetAngle;
            }

            float toPositiveRad(float rad)
            {
                return (rad + 2 * Mathf.PI) % (2 * Mathf.PI);
            }
        }
    }
}