using Cysharp.Threading.Tasks;
using Magify.Model;
using JetBrains.Annotations;

namespace Magify
{
    internal readonly struct SetupSavedContextJob : IMagifyWorkerJob
    {
    }

    internal class SetupSavedContextWorker : IMagifyWorker<SetupSavedContextJob>
    {
        [NotNull]
        private readonly ContextFileStorage _contextFileStorage;
        [NotNull]
        private readonly ContextApplicator _contextApplicator;

        public SetupSavedContextWorker(
            [NotNull] ContextFileStorage contextFileStorage,
            [NotNull] ContextApplicator contextApplicator)
        {
            _contextFileStorage = contextFileStorage;
            _contextApplicator = contextApplicator;
        }

        public void DoJob(SetupSavedContextJob job)
        {
            var json = _contextFileStorage.LoadContext();
            UniTask.RunOnThreadPool(applyContext).Forget();
            return;

            void applyContext()
            {
                var context = CampaignsContext.Deserialize(json);
                _contextApplicator.HandleContext(context, ContextKind.Saved);
            }
        }
    }
}