using Magify.Model;
using UnityEngine;

namespace Magify
{
    internal static class InternalModelExtensions
    {
        private static readonly MagifyLogger _logger = MagifyLogger.Get();

        internal static bool IsCorresponded(this CampaignSubscriptionStatus campaignSubscriptionStatus, SubscriptionStatus status)
        {
            return campaignSubscriptionStatus switch
            {
                CampaignSubscriptionStatus.AllUsers => true,
                CampaignSubscriptionStatus.FreeUsers => !status.IsActive(),
                CampaignSubscriptionStatus.Paid => status == SubscriptionStatus.Paid,
                CampaignSubscriptionStatus.Trial => status == SubscriptionStatus.Trial,
                CampaignSubscriptionStatus.TrialOrPaid => status.IsActive(),
                CampaignSubscriptionStatus.TrialCancelled => status == SubscriptionStatus.ExpiredTrial,
                CampaignSubscriptionStatus.PaidCancelled => status == SubscriptionStatus.ExpiredPaid,
                CampaignSubscriptionStatus.NeverSubscribed => status == SubscriptionStatus.Inactive,
                _ => notSupported(),
            };

            bool notSupported()
            {
                _logger.Log("Illegal campaign subscription status");
                return false;
            }
        }

        internal static bool IsCorresponded(this CampaignInAppStatus campaignInAppStatus, InAppStatus status)
        {
            return campaignInAppStatus switch
            {
                CampaignInAppStatus.AllUsers => true,
                CampaignInAppStatus.FreeUsers => status == InAppStatus.NeverPurchased,
                CampaignInAppStatus.PayingUsers => status == InAppStatus.Purchased,
                _ => notSupported(),
            };

            bool notSupported()
            {
                _logger.Log("Illegal campaign inapp status");
                return false;
            }
        }

        internal static bool IsCorresponded(this CampaignPayingStatus campaignPayingStatus, SubscriptionStatus subscriptionStatus, InAppStatus inAppStatus)
        {
            var isPayingUser = inAppStatus == InAppStatus.Purchased || subscriptionStatus.IsPaid();
            return campaignPayingStatus switch
            {
                CampaignPayingStatus.AllUsers => true,
                CampaignPayingStatus.PayingUsers => isPayingUser,
                CampaignPayingStatus.FreeUsers => !isPayingUser,
                _ => false
            };
        }

        internal static bool IsCorresponded(this CampaignAuthorizationStatus campaignAuthorizationStatus, AuthorizationStatus status)
        {
            return campaignAuthorizationStatus switch
            {
                CampaignAuthorizationStatus.AllUsers => true,
                CampaignAuthorizationStatus.Authorized => status == AuthorizationStatus.Authorized,
                CampaignAuthorizationStatus.Unauthorized => status == AuthorizationStatus.Unauthorized,
                _ => notSupported(),
            };

            bool notSupported()
            {
                _logger.Log("Illegal campaign authorization status");
                return false;
            }
        }
    }
}