using System;
using System.Globalization;
using System.Collections.Generic;
using JetBrains.Annotations;
using UnityEngine.Networking;

namespace Magify
{
    internal readonly struct WebResponseMessage
    {
        public UnityWebRequest.Result Result { get; init; }
        public long ResponseCode { get; init; }
        public string Error { get; init; }
        [CanBeNull]
        public string Text { get; init; }
        [CanBeNull]
        public IReadOnlyDictionary<string, string> Headers { get; init; }
        public WebRequestMessage RequestMessage { get; init; }

        public bool TryGetUnixTimeSeconds(out long unixTimeSec)
        {
            const string datePattern = "ddd, dd MMM yyyy HH:mm:ss 'GMT'";
            var dateFormat = CultureInfo.InvariantCulture.DateTimeFormat;
            if (Headers != null && Headers.TryGetValue("date", out var date))
            {
                if (DateTime.TryParseExact(date, datePattern, dateFormat, DateTimeStyles.AssumeUniversal, out var parsed))
                {
                    unixTimeSec = (long)Math.Round(parsed.ToUniversalTime().ToUnixMilliseconds() / 1000d);
                    return true;
                }
            }
            unixTimeSec = 0;
            return false;
        }

        public override string ToString()
        {
            return $"Result: {Result}\n" +
                   $"ResponseCode: {ResponseCode}\n" +
                   $"Error: {Error}\n" +
                   $"Text: {Text}\n" +
                   $"RequestMessage: {RequestMessage}";
        }
    }
}