using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;
using UnityEngine.Networking;

namespace Magify
{
    internal class UnityWebRequestOnMainThreadBuilder : IUnityWebRequestBuilder
    {
        [ItemNotNull]
        public UniTask<UnityWebRequest> Post(
            [NotNull] string url,
            [NotNull] byte[] uploadBytes,
            CancellationToken cancellationToken,
            int timeout)
        {
            return TaskScheduler.IsMainThread
                ? UniTask.FromResult(build())
                : TaskScheduler.RunOnMainThread(build, cancellationToken);

            [NotNull]
            UnityWebRequest build()
            {
                return new UnityWebRequest(url, UnityWebRequest.kHttpVerbPOST)
                {
                    uploadHandler = new UploadHandlerRaw(uploadBytes),
                    downloadHandler = new DownloadHandlerBuffer(),
                    timeout = timeout,
                };
            }
        }
    }
}