﻿using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    internal static class WebRequestMethods
    {
        [NotNull]
        public const string GetToken = "getToken";
        [NotNull]
        public const string ReissueToken = "reissueToken";
        [NotNull]
        public const string GetContext = "getContext";
        [NotNull]
        public const string Store = "store";
        [NotNull]
        public const string SaveTrustedPurchase = "save_trusted_purchase";

        [NotNull]
        public static string VerifyPurchase(RuntimePlatform runtimePlatform)
        {
            return runtimePlatform switch
            {
                RuntimePlatform.Android => "verify_purchase",
                RuntimePlatform.IPhonePlayer => "verify_receipt_data_v2",
                _ => throw new UnsupportedPlatformException(),
            };
        }
    }
}