﻿using System;
using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    internal static class ServerApiExtensions
    {
        [NotNull]
        private static readonly MagifyLogger _logger = MagifyLogger.Get(LoggingScope.Network);

        [ItemCanBeNull]
        public static async UniTask<string> GetAuthorizationTokenUntilSuccessAsync([NotNull] this IServerApi serverApi, CancellationToken cancellationToken)
        {
            var token = default(string);
            var backoff = new ExponentialBackoff(delayMilliseconds: 2, maxDelayMilliseconds: 64);
            while (token is null)
            {
                if (serverApi.IsOffline || serverApi.IsDisposed || cancellationToken.IsCancellationRequested)
                {
                    break;
                }
                try
                {
                    await UniTask.Delay((int)backoff.NextDelay(), cancellationToken: cancellationToken);
                    token = await serverApi.GetAuthorizationTokenAsync(cancellationToken);
                }
                catch (OperationCanceledException e)
                {
                    _logger.Log($"Failed to get authorization token. Reason: {e.Message}. Trying again...");
                }
            }
            return token;
        }
    }
}