﻿using System;
using JetBrains.Annotations;

namespace Magify
{
    internal readonly struct RequestConfig
    {
        [NotNull]
        public string Method { get; }
        [NotNull]
        public Func<WebRequestMessage> RequestMessageGetter { get; }
        public bool UseWebRequestWithRepeats { get; }
        public bool IsAuthTokenRequired { get; }

        public RequestConfig(
            [NotNull] string method,
            [NotNull] Func<WebRequestMessage> requestMessageGetter,
            bool useWebRequestWithRepeats,
            bool isAuthTokenRequired)
        {
            Method = method;
            RequestMessageGetter = requestMessageGetter;
            UseWebRequestWithRepeats = useWebRequestWithRepeats;
            IsAuthTokenRequired = isAuthTokenRequired;
        }
    }
}