﻿using JetBrains.Annotations;

namespace Magify
{
    internal static class AuthTokenDecoder
    {
        /// <exception cref="TooShortMagifyTokenException">
        /// Thrown when the token is too short to be decoded.
        /// </exception>
        /// <exception cref="DecodeException">
        /// Thrown when the token is not a valid Base64 encoded string.
        /// </exception>
        [CanBeNull]
        public static string RetrieveClientFromToken([NotNull] string authToken)
        {
            var payload = JwtDecoder.DecodePayload(authToken);
            return payload.Issuer?.ClientId;
        }
    }
}