using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class TokenResponse
    {
        [JsonProperty("id")]
        public string Id { get; set; }

        [JsonProperty("result")]
        public string Token { get; set; }
    }

    internal class JwtPayload
    {
        [JsonProperty("jti"), CanBeNull]
        public string Id { get; init; }

        [JsonProperty("iss"), CanBeNull]
        public JwtIssuer Issuer { get; init; }
    }

    internal class JwtIssuer
    {
        [JsonProperty("id"), CanBeNull]
        public string ClientId { get; init; }

        [JsonProperty("app_name"), CanBeNull]
        public string AppName { get; init; }

        [JsonProperty("app_version"), CanBeNull]
        public string AppVersion { get; init; }

        [JsonProperty("device_name"), CanBeNull]
        public string DeviceName { get; init; }

        [JsonProperty("device_version"), CanBeNull]
        public string DeviceVersion { get; init; }

        [JsonProperty("sdk_version"), CanBeNull]
        public string SdkVersion { get; init; }
    }
}