using System.Collections.Generic;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class StorePayload
    {
        [JsonProperty("model")]
        public EventType Model { get; set; }

        [JsonProperty("objects")]
        public IEnumerable<object> Objects { get; set; }

        public override string ToString()
        {
            return $"Model: {Model}, Objects: {JsonFacade.SerializeObject(Objects)}";
        }
    }
}