﻿using Newtonsoft.Json;

namespace Magify.Model
{
    internal struct JsonRPCPayload
    {
        [JsonProperty("method")]
        public readonly string MethodName;

        [JsonProperty("params")]
        public readonly object Params;

        [JsonProperty("id")]
        public readonly string Id;

        [JsonProperty("jsonrpc")]
        public readonly string Version;

        public JsonRPCPayload(string method, object payloadParams, string payloadId = "1", string payloadVersion = "2.0")
        {
            MethodName = method;
            Params = payloadParams;
            Id = payloadId;
            Version = payloadVersion;
        }
    }
}