using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class DefaultProduct
    {
        [JsonProperty("product_id")]
        public string ProductId { get; set; }

        [JsonProperty("type")]
        public ProductType? Type { get; set; }

        [JsonProperty("product_context")]
        [CanBeNull]
        public Dictionary<string, object> ProductContext { get; set; } = new Dictionary<string, object>();

        [JsonProperty("store_names"), CanBeNull]
        public PurchaseStore[] Stores { get; set; }
    }
}