using System;
using Newtonsoft.Json;
using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify.Model
{
    internal class Limits
    {
        [JsonProperty("sessions_interval")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Second, true)]
        [CanBeNull]
        public TimeSpan? SessionsInterval { get; set; }

        [JsonProperty("global_interval")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Second, true)]
        [CanBeNull]
        public TimeSpan? GlobalInterval { get; set; }

        [JsonProperty("interstitial_interval")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Second, true)]
        [CanBeNull]
        public TimeSpan? InterstitialInterval { get; set; }

        [JsonProperty("rv_interstitial_interval")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Second, true)]
        [CanBeNull]
        public TimeSpan? RewardedInterstitialInterval { get; set; }

        [JsonProperty("impression_per_session_limit")]
        [CanBeNull]
        public int? ImpressionsPerSession { get; set; }

        [JsonProperty("interstitials_limits")]
        [CanBeNull]
        [LimitsForCampaignType(CampaignType.Interstitial)]
        public ImpressionLimits InterstitialLimits { get; set; }

        [JsonProperty("inapps_limits")]
        [CanBeNull]
        [LimitsForCampaignType(CampaignType.InApp)]
        public ImpressionLimits InAppLimits { get; set; }

        [JsonProperty("lto_inapps_limits")]
        [CanBeNull]
        [LimitsForCampaignType(CampaignType.LtoInApp)]
        public ImpressionLimits LtoInAppLimits { get; set; }

        [JsonProperty("subscriptions_limits")]
        [CanBeNull]
        [LimitsForCampaignType(CampaignType.Subscription)]
        public ImpressionLimits SubscriptionLimits { get; set; }

        [JsonProperty("lto_subscriptions_limits")]
        [CanBeNull]
        [LimitsForCampaignType(CampaignType.LtoSubscription)]
        public ImpressionLimits LtoSubscriptionLimits { get; set; }

        [JsonProperty("cross_promos_limits")]
        [CanBeNull]
        [LimitsForCampaignType(CampaignType.CrossPromo)]
        public ImpressionLimits CrossPromoLimits { get; set; }

        [JsonProperty("lto_cross_promos_limits")]
        [CanBeNull]
        [LimitsForCampaignType(CampaignType.LtoCrossPromo)]
        public ImpressionLimits LtoCrossPromoLimits { get; set; }

        [JsonProperty("notifications_limits")]
        [CanBeNull]
        [LimitsForCampaignType(CampaignType.Notification)]
        public ImpressionLimits NotificationLimits { get; set; }

        [JsonProperty("externals_limits")]
        [CanBeNull]
        [LimitsForCampaignType(CampaignType.External)]
        public ImpressionLimits ExternalLimits { get; set; }

        [JsonProperty("lto_externals_limits")]
        [CanBeNull]
        [LimitsForCampaignType(CampaignType.LtoExternal)]
        public ImpressionLimits LtoExternalLimits { get; set; }

        [JsonProperty("rate_and_reviews_limits")]
        [CanBeNull]
        [LimitsForCampaignType(CampaignType.RateReview)]
        public ImpressionLimits RateReviewLimits { get; set; }

        [JsonProperty("temporary_limits")]
        [CanBeNull]
        public List<TemporaryLimitsGroup> TempLimits { get; set; }
    }
}