using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class CampaignModel
    {
        [JsonProperty("campaign_type")]
        [CanBeNull]
        public CampaignType? Type { get; set; }

        [JsonProperty("name")]
        public string Name { get; set; }

        [JsonProperty("info")]
        [CanBeNull]
        public MetaInfo Info { get; set; }

        [JsonProperty("events")]
        [CanBeNull]
        public List<Event> Events { get; set; }

        [JsonProperty("placements")]
        [CanBeNull]
        public List<string> Placements { get; set; }

        [JsonProperty("subscription_status")]
        [CanBeNull]
        public CampaignSubscriptionStatus? SubscriptionStatus { get; set; }

        [JsonProperty("social_authorization_status")]
        [CanBeNull]
        public CampaignAuthorizationStatus? AuthorizationStatus { get; set; }

        [JsonProperty("inapp_status")]
        [CanBeNull]
        public CampaignInAppStatus? InAppStatus { get; set; }

        [JsonProperty("paying_status")]
        [CanBeNull]
        public CampaignPayingStatus? PayingStatus { get; set; }

        [JsonProperty("exclude_if_all_purchased")]
        [CanBeNull]
        public List<PurchasedItem> ExcludeIfAllPurchased { get; set; }

        [JsonProperty("exclude_if_any_purchased")]
        [CanBeNull]
        public List<PurchasedItem> ExcludeIfAnyPurchased { get; set; }

        [JsonProperty("include_if_all_purchased")]
        [CanBeNull]
        public List<PurchasedItem> IncludeIfAllPurchased { get; set; }

        [JsonProperty("include_if_any_purchased")]
        [CanBeNull]
        public List<PurchasedItem> IncludeIfAnyPurchased { get; set; }

        [JsonProperty("impression_limit")]
        [CanBeNull]
        public ImpressionLimits ImpressionLimit { get; set; }

        [JsonProperty("click_limit")]
        [CanBeNull]
        public int? ClickLimit { get; set; }

        [JsonProperty("nested_campaigns")]
        [CanBeNull]
        public List<NestedCampaign> NestedCampaigns { get; set; }

        [JsonProperty("store_name")]
        [CanBeNull]
        public PurchaseStore Store { get; set; }

        [JsonProperty("include_referrer_ids")]
        [CanBeNull]
        public List<ReferrerItem> IncludeReferrerIds { get; set; }

        [JsonProperty("exclude_referrer_ids")]
        [CanBeNull]
        public List<ReferrerItem> ExcludeReferrerIds { get; set; }

        [JsonProperty("triggers")]
        [CanBeNull]
        public List<Trigger> Triggers { get; set; }

        [JsonProperty("spots")]
        [CanBeNull]
        public List<Spot> Spots { get; set; }

        [JsonProperty("tag")]
        [CanBeNull]
        public LtoTag LtoTag { get; set; }

        [JsonProperty("badge")]
        [CanBeNull]
        public BadgeCreativeModel LtoBadge { get; set; }

        [JsonProperty("start_at")]
        [JsonConverter(typeof(UnitDateTimeConverter), TimeUnit.Second)]
        [CanBeNull]
        public DateTime? StartsAt { get; set; }

        [JsonProperty("end_at")]
        [JsonConverter(typeof(UnitDateTimeConverter), TimeUnit.Second)]
        [CanBeNull]
        public DateTime? EndsAt { get; set; }

        [JsonProperty("timezone")]
        [CanBeNull]
        public Timezone? Timezone { get; set; }

        [JsonProperty("finished_at")]
        [JsonConverter(typeof(UnitDateTimeConverter), TimeUnit.Second)]
        [CanBeNull]
        public DateTime? FinishAt { get; set; }

        [JsonProperty("activation_period")]
        [CanBeNull]
        public ActivationPeriod ActivationPeriod { get; set; }

        [JsonProperty("duration")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Minute)]
        [CanBeNull]
        public TimeSpan? Duration { get; set; }

        [JsonProperty("delay")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Minute)]
        [CanBeNull]
        public TimeSpan? Delay { get; set; }

        [JsonProperty("activation_limit")]
        [CanBeNull]
        public int? ActivationLimit { get; set; }

        [JsonProperty("activation_limit_per_day")]
        [CanBeNull]
        public int? DailyActivationLimit { get; set; }

        [JsonProperty("impression_limit_per_activation")]
        [CanBeNull]
        public int? ImpressionLimitPerActivation { get; set; }

        [JsonProperty("app_version")]
        [CanBeNull]
        public VersionLimit AppVersionLimit { get; set; }

        [JsonProperty("is_stopped_by_purchase")]
        [CanBeNull]
        public bool? StopOfferOnPurchase { get; set; }

        [JsonProperty("is_over_after_watching")]
        [CanBeNull]
        public bool? ShouldStopRewardOfferAfterWatch { get; set; }

        [JsonProperty("is_over_after_watching_rv")]
        [CanBeNull]
        public int? StopRewardOfferAfterWatchLimit { get; set; }

        [JsonProperty("global_rv_limit")]
        [CanBeNull]
        public int? GlobalRewardLimit { get; set; }

        [JsonProperty("session_rv_limit")]
        [CanBeNull]
        public int? SessionRewardLimit { get; set; }

        [JsonProperty("daily_rv_limit")]
        [CanBeNull]
        public int? DailyRewardLimit { get; set; }

        [JsonProperty("global_bonus_limit")]
        [CanBeNull]
        public int? GlobalBonusLimit { get; set; }

        [JsonProperty("session_bonus_limit")]
        [CanBeNull]
        public int? SessionBonusLimit { get; set; }

        [JsonProperty("daily_bonus_limit")]
        [CanBeNull]
        public int? DailyBonusLimit { get; set; }

        [JsonProperty("is_cached")]
        [CanBeNull]
        public bool? IsLtoCached { get; set; }
    }
}