using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class BadgeCreativeInfo
    {
        [JsonProperty("tag")]
        public string Tag { get; set; }

        [JsonProperty("is_timer_hidden")]
        [CanBeNull]
        public bool? IsTimerHidden { get; set; }

        [JsonProperty("text")]
        [CanBeNull]
        public string LabelText { get; set; }

        [JsonProperty("title")]
        [CanBeNull]
        public string Title { get; set; }

        [JsonProperty("last_minutes_timer")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Minute)]
        [CanBeNull]
        public TimeSpan? LastMinutesTimer { get; set; }

        [JsonProperty("value")]
        [CanBeNull]
        public Dictionary<string, object> Attributes { get; set; }

        [JsonProperty("image")]
        [CanBeNull]
        public string ImageUrl { get; set; }

        [JsonProperty("compressed_lottie")]
        [CanBeNull]
        public string BundleUrl { get; set; }

        public bool Equals(BadgeCreativeInfo other)
        {
            return Tag == other.Tag &&
                   IsTimerHidden == other.IsTimerHidden &&
                   LabelText == other.LabelText &&
                   Title == other.Title &&
                   LastMinutesTimer == other.LastMinutesTimer &&
                   ImageUrl == other.ImageUrl &&
                   BundleUrl == other.BundleUrl &&
                   // TODO: need to check this logic - not sure that Compare works as expected here
                   (Attributes == other.Attributes || Attributes.Compare(other.Attributes));
        }
    }
}