﻿using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;
using UnityEngine;

namespace Magify.Model
{
    internal class ApplicationState
    {
        [JsonProperty("client_state"), CanBeNull]
        public string ClientState { get; set; }

        [JsonProperty("sdk_by_platform"), CanBeNull]
        public Dictionary<RuntimePlatform, PlatformSdk> SdkByPlatform { get; set; }

        [CanBeNull]
        public PlatformSdk Sdk(RuntimePlatform platform)
        {
            return SdkByPlatform != null && SdkByPlatform.TryGetValue(platform, out var platformSdk)
                ? platformSdk
                : default;
        }

        public class PlatformSdk
        {
            [JsonProperty("general_prefs"), CanBeNull]
            public string GeneralPrefs { get; set; }

            [JsonProperty("counters_prefs"), CanBeNull]
            public string CountersPrefs { get; set; }

            [JsonIgnore]
            public bool IsEmpty => string.IsNullOrEmpty(GeneralPrefs) && string.IsNullOrEmpty(CountersPrefs);

            public PlatformSdk([CanBeNull] string generalPrefs, [CanBeNull] string countersPrefs)
            {
                GeneralPrefs = generalPrefs;
                CountersPrefs = countersPrefs;
            }
        }
    }
}