using System;
using System.Collections.Generic;
using System.Linq;
using JetBrains.Annotations;
using Magify.Model;

namespace Magify
{
    internal class OffersStorage : FileStorage
    {
        private const string ModelsFileName = "lto.json";
        private const string CampaignsFileName = "lto_campaigns.json";

        public OffersStorage(string storagePath) : base(storagePath)
        {
        }

        public bool Exists()
        {
            return Exists(ModelsFileName);
        }

        [CanBeNull]
        public List<LtoModel> LoadActiveOffers(CampaignsCollection campaignsCollection)
        {
            var offersJson = Load(ModelsFileName);
            if (string.IsNullOrEmpty(offersJson))
            {
                return null;
            }
            var offers = JsonFacade.DeserializeObject<List<LtoModel>>(offersJson);
            var campaignsJson = Load(CampaignsFileName);
            IReadOnlyList<CampaignRecord> campaigns = string.IsNullOrEmpty(campaignsJson)
                ? ArraySegment<CampaignRecord>.Empty
                : CampaignMapper.MapCampaigns(JsonFacade.DeserializeObject<List<CampaignModel>>(campaignsJson));

            foreach (var model in offers)
            {
                model.Record = campaigns.FirstOrDefault(c => c.Name == model.CampaignName)
                            ?? campaignsCollection.CurrentCampaigns.FirstOrDefault(c => c.Name == model.CampaignName)
                            ?? campaignsCollection.DefaultCampaigns.FirstOrDefault(c => c.Name == model.CampaignName);
                if (model.Record != null)
                {
                    model.RebuildBadgeCreative();
                }
            }

            return offers;
        }

        public void SaveActiveOffers(IReadOnlyCollection<LtoModel> items)
        {
            Save(ModelsFileName, JsonFacade.SerializeObject(items));
            Save(CampaignsFileName, JsonFacade.SerializeObject(items.Where(c => c.Campaign != null).Select(c => c.Campaign)));
        }
    }
}