using System;
using JetBrains.Annotations;
using Magify.Model;

namespace Magify
{
    internal class OffersPrefs : IDisposable
    {
        private CampaignsContext _context;
        private readonly BinaryStorage _storage;

        public DateTime GetLastOfferStartTime(string name)
        {
            return _storage.Get($"start_time_{name}", default(DateTime));
        }

        public void SetLastOfferStartTime(string name, DateTime dateTime)
        {
            _storage.Set($"start_time_{name}", dateTime);
        }

        public void ResetLastOfferStartTime(string name)
        {
            _storage.Remove<DateTime>($"start_time_{name}");
        }

        public DateTime GetLastOfferEndTime(string name)
        {
            return _storage.Get($"end_time_{name}", default(DateTime));
        }

        public void SetLastOfferEndTime(string name, DateTime dateTime)
        {
            _storage.Set($"end_time_{name}", dateTime);
        }

        [NotNull]
        public static OffersPrefs Create(string storagePath)
        {
            var storage = BinaryStorage
                .Construct(storagePath)
                .AddPrimitiveTypes()
                .Build();

            var prefs = new OffersPrefs(storage);
            return prefs;
        }

        private OffersPrefs(BinaryStorage storage)
        {
            _storage = storage;
        }

        void IDisposable.Dispose()
        {
            _storage?.Dispose();
        }
    }
}