using JetBrains.Annotations;
using Magify.Model;
using Newtonsoft.Json;
using UnityEngine.Scripting;

namespace Magify
{
    [Preserve]
    internal class LtoModel : LtoInfo
    {
        [Preserve]
        [JsonProperty("has_priority")]
        public bool HasPriority { get; set; }

        [Preserve]
        [JsonProperty("trigger")]
        public string Trigger { get; init; }

        [Preserve]
        [CanBeNull]
        [JsonProperty("badge_placeholder")]
        public string BadgePlaceholder { get; init; }

        [JsonIgnore]
        [CanBeNull]
        public CampaignRecord Record { get; set; }

        [JsonIgnore]
        public CampaignModel Campaign => Record?.Campaign;

        [JsonIgnore]
        public CampaignInfo Info => Record?.Info;

        public void RebuildBadgeCreative()
        {
            var resource = new CreativeResource
            {
                Type = Campaign.LtoBadge?.Info.ImageUrl != null ? CreativeResource.ArtifactType.Image : CreativeResource.ArtifactType.Bundle,
                Url = Campaign.LtoBadge?.Info.ImageUrl ?? Campaign.LtoBadge?.Info.BundleUrl
            };

            BadgeCreative = new LtoBadgeCreative
            {
                Tag = Campaign.LtoBadge?.Info.Tag,
                Title = Campaign.LtoBadge?.Info.Title,
                LabelText = Campaign.LtoBadge?.Info.LabelText,
                Resource = resource,
                Placeholder = BadgePlaceholder,
                HasTimer = !Campaign.LtoBadge?.Info.IsTimerHidden ?? false,
                LastMinutesTimer = (int)(Campaign.LtoBadge?.Info.LastMinutesTimer?.TotalMinutes ?? 0),
                Attributes = Campaign.LtoBadge?.Info.Attributes
            };
        }
    }
}