using System.Linq;
using Magify.Model;

namespace Magify
{
    internal static class PositioningExtensions
    {
        internal static bool Contains(this Positioning positions, int value)
        {
            if (positions.FixedPositions != null && positions.FixedPositions.Contains(value))
                return true;
            
            if (positions.EndPosition != null && value > positions.EndPosition)
                return false;

            if (positions.Period == null)
                return false;

            var start = positions.StartPosition ?? positions.Period;
            return value switch
            {
                _ when value == start => true,
                _ when value > start => positions.Period != 0 && (value - start) % positions.Period == 0,
                _ => false
            };
        }
    }
}